# $Id: install-new.mk,v 1.6 2025/08/09 22:42:24 sjg Exp $
#
#	@(#) Copyright (c) 2009, Simon J. Gerraty
#
#	SPDX-License-Identifier: BSD-2-Clause
#
#	Please send copies of changes and bug-fixes to:
#	sjg@crufty.net
#

.if !defined(InstallNew)

# copy if src and target are different making a backup if desired
CmpCp= CmpCp() { \
	src=$$1 target=$$2 _bak=$$3; \
	if ! test -s $$target || ! cmp -s $$target $$src; then \
		trap "" 1 2 3 15; \
		if test -s $$target; then \
			if test "x$$_bak" != x; then \
				rm -f $$target$$_bak; \
				mv $$target $$target$$_bak; \
			else \
				rm -f $$target; \
			fi; \
		fi; \
		cp $$src $$target; \
	fi; }

# If the .new file is different, we want it.
# Note: this function will work as is for *.new$RANDOM"
InstallNew= ${CmpCp}; InstallNew() { \
	_t=-e; _bak=; \
	while :; do \
		case "$$1" in \
		-?) _t=$$1; shift;; \
		--bak) _bak=$$2; shift 2;; \
		*) break;; \
		esac; \
	done; \
	for new in "$$@"; do \
		if test $$_t $$new; then \
			target=`expr $$new : '\(.*\).new'`; \
			CmpCp $$new $$target $$_bak; \
		fi; \
		rm -f $$new; \
	done; :; }

.endif
